/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.datagen;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kiwiapollo.cobblemontrainerbattle.datagen.CustomAdvancements;
import kiwiapollo.cobblemontrainerbattle.datagen.DefeatTrainerAdvancements;
import kiwiapollo.cobblemontrainerbattle.datagen.InclementEmeraldAdvancements;
import kiwiapollo.cobblemontrainerbattle.datagen.InclementEmeraldTicketRecipeGenerator;
import kiwiapollo.cobblemontrainerbattle.datagen.KillTrainerAdvancements;
import kiwiapollo.cobblemontrainerbattle.datagen.RadicalRedAdvancements;
import kiwiapollo.cobblemontrainerbattle.datagen.RadicalRedTicketRecipeGenerator;
import kiwiapollo.cobblemontrainerbattle.datagen.TrainerEntityLootTableProvider;
import kiwiapollo.cobblemontrainerbattle.datagen.VsSeekerRecipeGenerator;
import kiwiapollo.cobblemontrainerbattle.entity.EntityTypes;
import kiwiapollo.cobblemontrainerbattle.item.ItemTagRegistry;
import kiwiapollo.cobblemontrainerbattle.item.MiscItems;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_161;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5258;
import net.minecraft.class_5341;
import net.minecraft.class_5409;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8779;
import net.minecraft.class_8790;

public class DataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(AdvancementProvider::new);
        pack.addProvider(RecipeProvider::new);
        pack.addProvider(TagProvider::new);
        pack.addProvider(TrainerEntityLootTableProvider::new);
    }

    private static class TagProvider
    extends FabricTagProvider<class_1792> {
        public TagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, class_7924.field_41197, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 lookup) {
            this.getOrCreateTagBuilder(ItemTagRegistry.VS_SEEKERS).add((Object)MiscItems.BLUE_VS_SEEKER).add((Object)MiscItems.RED_VS_SEEKER).add((Object)MiscItems.GREEN_VS_SEEKER).add((Object)MiscItems.PURPLE_VS_SEEKER);
        }
    }

    private static class RecipeProvider
    extends FabricRecipeProvider {
        private RecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public void method_10419(class_8790 exporter) {
            new VsSeekerRecipeGenerator().generate(exporter);
            new InclementEmeraldTicketRecipeGenerator().generate(exporter);
            new RadicalRedTicketRecipeGenerator().generate(exporter);
        }
    }

    static class AdvancementProvider
    extends FabricAdvancementProvider {
        static final class_2960 BACKGROUND = class_2960.method_60654((String)"textures/gui/advancements/backgrounds/adventure.png");
        static final class_8779 ROOT = class_161.class_162.method_51698().method_705("root", class_174.field_25694.method_53699((class_184)new class_5409.class_5410(Optional.of(class_5258.method_27973((class_5341[])new class_5341[0])), Optional.of(class_2073.class_2074.method_8973().method_8976()), Optional.of(class_2048.method_51704((class_2048)class_2048.class_2049.method_8916().method_8921(EntityTypes.TRAINER).method_8920()))))).method_697((class_1935)class_7923.field_41178.method_10223(class_2960.method_60655((String)"cobblemon", (String)"link_cable")), (class_2561)class_2561.method_43471((String)"advancement.cobblemontrainerbattle.root.title"), (class_2561)class_2561.method_43471((String)"advancement.cobblemontrainerbattle.root.description"), BACKGROUND, class_189.field_1254, true, true, false).method_695(class_2960.method_60655((String)"cobblemontrainerbattle", (String)"root"));

        protected AdvancementProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public void generateAdvancement(class_7225.class_7874 registryLookup, Consumer<class_8779> consumer) {
            consumer.accept(ROOT);
            Arrays.stream(DefeatTrainerAdvancements.values()).map(CustomAdvancements::getAdvancement).forEach(consumer);
            Arrays.stream(KillTrainerAdvancements.values()).map(CustomAdvancements::getAdvancement).forEach(consumer);
            Arrays.stream(InclementEmeraldAdvancements.values()).map(CustomAdvancements::getAdvancement).forEach(consumer);
            Arrays.stream(RadicalRedAdvancements.values()).map(CustomAdvancements::getAdvancement).forEach(consumer);
        }
    }
}

